<?php

class FileManagerUI
{
    /******************************************************
     * BREADCRUMB
     ******************************************************/
    public static function renderBreadcrumb($crumbs, $current)
    {
        echo '<nav aria-label="breadcrumb"><ol class="breadcrumb">';
        foreach ($crumbs as $c) {
            $active = ($c["id"] === $current) ? "active" : "";
            echo '<li class="breadcrumb-item ' . $active . '">';
            if ($active) {
                echo htmlspecialchars($c["name"]);
            } else {
                echo '<a href="?folder=' . $c["id"] . '">' . htmlspecialchars($c["name"]) . '</a>';
            }
            echo '</li>';
        }
        echo '</ol></nav>';
    }

    /******************************************************
     * LISTA DE ARCHIVOS / CARPETAS
     ******************************************************/
    public static function renderList($items)
    {
        echo '<table class="table table-hover mt-3">';
        echo '<thead class="table-dark">
                <tr>
                    <th>Nombre</th>
                    <th>Tipo</th>
                    <th>Tamaño</th>
                    <th>Acciones</th>
                </tr>
              </thead>';
        echo '<tbody>';

        foreach ($items as $item) {
            $isFolder = isset($item["folder"]);
            $name = htmlspecialchars($item["name"]);
            $size = $isFolder ? "-" : number_format($item["size"] ?? 0) . " bytes";

            echo "<tr>";

            echo "<td>";
            if ($isFolder) {
                echo '<a href="?folder=' . $item["id"] . '">📁 ' . $name . '</a>';
            } else {
                echo '📄 ' . $name;
            }
            echo "</td>";

            echo "<td>" . ($isFolder ? "Carpeta" : "Archivo") . "</td>";
            echo "<td>$size</td>";

            echo '<td>';

            if (!$isFolder) {
                echo '<a class="btn btn-sm btn-primary me-1" href="download.php?id=' . $item["id"] . '">Descargar</a>';
            }

            // Renombrar
            echo '
                <button class="btn btn-sm btn-warning me-1"
                    data-bs-toggle="modal" 
                    data-bs-target="#renameModal"
                    data-id="' . $item["id"] . '"
                    data-name="' . $name . '">Renombrar</button>';

            // Borrar
            echo '
                <button class="btn btn-sm btn-danger"
                    data-bs-toggle="modal" 
                    data-bs-target="#deleteModal"
                    data-id="' . $item["id"] . '"
                    data-name="' . $name . '">Borrar</button>';

            echo "</td>";

            echo "</tr>";
        }

        echo "</tbody></table>";

        self::modalRename();
        self::modalDelete();
    }

    /******************************************************
     * FORMULARIOS
     ******************************************************/
    public static function renderForms($folderId)
    {
        echo '

        <div class="row mb-4">

            <div class="col-md-6">
                <form class="card p-3" method="post" enctype="multipart/form-data">
                    <h5>Subir archivo</h5>
                    <input type="hidden" name="action" value="upload">
                    <input type="hidden" name="folder" value="' . $folderId . '">

                    <input type="file" name="archivo" class="form-control mt-2" required>
                    <button class="btn btn-success mt-2">Subir</button>
                </form>
            </div>

            <div class="col-md-6">
                <form class="card p-3" method="post">
                    <h5>Crear carpeta</h5>
                    <input type="hidden" name="action" value="create_folder">
                    <input type="hidden" name="folder" value="' . $folderId . '">

                    <input class="form-control mt-2" type="text" name="folder_name" placeholder="Nombre" required>
                    <button class="btn btn-primary mt-2">Crear</button>
                </form>
            </div>

        </div>
        ';
    }

    /******************************************************
     * MODAL RENOMBRAR
     ******************************************************/
    private static function modalRename()
    {
        echo '
        <div class="modal fade" id="renameModal" tabindex="-1">
          <div class="modal-dialog">
            <form class="modal-content" method="post">
              <div class="modal-header">
                <h5 class="modal-title">Renombrar</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>

              <div class="modal-body">
                <input type="hidden" name="action" value="rename">
                <input type="hidden" name="item_id" id="rename_id">

                <label>Nuevo nombre:</label>
                <input type="text" name="new_name" id="rename_name" class="form-control" required>
              </div>

              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button class="btn btn-primary">Renombrar</button>
              </div>
            </form>
          </div>
        </div>

        <script>
        const rModal = document.getElementById("renameModal");
        rModal.addEventListener("show.bs.modal", e => {
            const btn = e.relatedTarget;
            document.getElementById("rename_id").value = btn.dataset.id;
            document.getElementById("rename_name").value = btn.dataset.name;
        });
        </script>
        ';
    }

    /******************************************************
     * MODAL BORRAR
     ******************************************************/
    private static function modalDelete()
    {
        echo '
        <div class="modal fade" id="deleteModal" tabindex="-1">
          <div class="modal-dialog">
            <form class="modal-content" method="post">
              <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">Eliminar</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>

              <div class="modal-body">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="item_id" id="delete_id">

                <p>¿Seguro deseas eliminar <strong id="delete_name"></strong>?</p>
              </div>

              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button class="btn btn-danger">Eliminar</button>
              </div>
            </form>
          </div>
        </div>

        <script>
        const dModal = document.getElementById("deleteModal");
        dModal.addEventListener("show.bs.modal", e => {
            const btn = e.relatedTarget;
            document.getElementById("delete_id").value = btn.dataset.id;
            document.getElementById("delete_name").innerText = btn.dataset.name;
        });
        </script>
        ';
    }
}
